//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <stdbool.h>

#define TRUE 1
#define FALSE 0
#define SNAPLEN 1514
#define DATALEN 65535
#define PROMISCUOUS 1

// Function to print the hex dump of the packet data
void print_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    int i = 0;
    printf("Packet %d:\n", header->caplen);
    for (i = 0; i < header->caplen; i++) {
        printf("%02X ", packet[i]);
        if ((i + 1) % 16 == 0) {
            printf("\n");
        }
    }
    printf("\n");
}

// Function to handle the captured packets
void got_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    print_packet(args, header, packet);
}

// Main function to capture packets
int main(int argc, char *argv[]) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    char filter_exp[] = "tcp port 80";
    struct bpf_program fp;
    int net = 0, mask = 0;
    char *dev = NULL;
    int promisc = 0;
    int timeout = 0;
    int max_packets = 100;

    // Get the default device
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        printf("Error: %s\n", errbuf);
        exit(1);
    }

    // Open the session
    handle = pcap_open_live(dev, SNAPLEN, promisc, timeout, errbuf);
    if (handle == NULL) {
        printf("Error: %s\n", errbuf);
        exit(1);
    }

    // Set the filter expression
    if (pcap_compile(handle, &fp, filter_exp, 0, net) == -1) {
        printf("Error: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Set the filter
    if (pcap_setfilter(handle, &fp) == -1) {
        printf("Error: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Loop to capture packets
    pcap_loop(handle, -1, got_packet, NULL);

    // Close the session
    pcap_freecode(&fp);
    pcap_close(handle);

    return 0;
}