//Falcon2-11B DATASET v1.0 Category: TCP/IP Programming ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <unistd.h>

int main() {
    int sockfd, portno, n;
    struct sockaddr_in serv_addr;
    char buffer[256];
    char message[] = "Hello, World!";

    // Create a TCP/IP socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Assign a port number to the socket
    portno = 8080;
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);

    // Assign IP address to the socket
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("Error connecting to server");
        exit(1);
    }

    // Send a message to the server
    n = send(sockfd, message, sizeof(message), 0);
    if (n < 0) {
        perror("Error sending message");
        exit(1);
    }

    // Receive a response from the server
    bzero(buffer, sizeof(buffer));
    n = recv(sockfd, buffer, sizeof(buffer), 0);
    if (n < 0) {
        perror("Error receiving response");
        exit(1);
    }

    // Close the connection
    close(sockfd);

    printf("Received response: %s\n", buffer);

    return 0;
}