//GEMINI-pro DATASET v1.0 Category: Color Code Converter ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the color code structure
typedef struct ColorCode {
    char *name;
    int r;
    int g;
    int b;
} ColorCode;

// Define an array of color codes
ColorCode colorCodes[] = {
    { "black", 0, 0, 0 },
    { "white", 255, 255, 255 },
    { "red", 255, 0, 0 },
    { "green", 0, 255, 0 },
    { "blue", 0, 0, 255 },
    { "yellow", 255, 255, 0 },
    { "magenta", 255, 0, 255 },
    { "cyan", 0, 255, 255 },
    { "orange", 255, 165, 0 },
    { "purple", 128, 0, 128 },
    { "brown", 165, 42, 42 },
    { "gray", 128, 128, 128 }
};

// Define the number of color codes
#define NUM_COLOR_CODES (sizeof(colorCodes) / sizeof(ColorCode))

// Define the function to print the color codes
void printColorCodes() {
    for (int i = 0; i < NUM_COLOR_CODES; i++) {
        printf("%s: (%d, %d, %d)\n", colorCodes[i].name, colorCodes[i].r, colorCodes[i].g, colorCodes[i].b);
    }
}

// Define the function to get the color code by name
ColorCode *getColorCodeByName(char *name) {
    for (int i = 0; i < NUM_COLOR_CODES; i++) {
        if (strcmp(colorCodes[i].name, name) == 0) {
            return &colorCodes[i];
        }
    }

    return NULL;
}

// Define the function to get the color code by RGB values
ColorCode *getColorCodeByRGB(int r, int g, int b) {
    for (int i = 0; i < NUM_COLOR_CODES; i++) {
        if (colorCodes[i].r == r && colorCodes[i].g == g && colorCodes[i].b == b) {
            return &colorCodes[i];
        }
    }

    return NULL;
}

// Define the main function
int main() {
    // Print the color codes
    printColorCodes();

    // Get the color code by name
    ColorCode *colorCode = getColorCodeByName("red");
    if (colorCode != NULL) {
        printf("The color code for %s is (%d, %d, %d)\n", colorCode->name, colorCode->r, colorCode->g, colorCode->b);
    } else {
        printf("The color code for red was not found.\n");
    }

    // Get the color code by RGB values
    colorCode = getColorCodeByRGB(255, 0, 0);
    if (colorCode != NULL) {
        printf("The color code for (%d, %d, %d) is %s\n", colorCode->r, colorCode->g, colorCode->b, colorCode->name);
    } else {
        printf("The color code for (255, 0, 0) was not found.\n");
    }

    return 0;
}