//LLAMA2-13B DATASET v1.0 Category: Interprocess communication ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define MESSAGE_SIZE 1024

int main() {
    // Create a shared memory segment
    key_t key = IPC_PRIVATE;
    int shmid = shmget(key, MESSAGE_SIZE, IPC_CREAT | 0644);
    if (shmid == -1) {
        perror("shmget");
        return 1;
    }

    // Attach to the shared memory segment
    void *shm = shmat(shmid, NULL, 0);
    if (shm == (void *) -1) {
        perror("shmat");
        return 1;
    }

    // Write a message to the shared memory
    char message[MESSAGE_SIZE];
    snprintf(message, MESSAGE_SIZE, "SURPRISE! YOU JUST GOT MESSAGE FROM ANOTHER PROCESS!");
    if (msync(shm, MESSAGE_SIZE, MS_ASYNC) == -1) {
        perror("msync");
        return 1;
    }

    // Sleep for a bit to make it look like we're waiting for a response
    sleep(5);

    // Read the message from the shared memory
    char read_message[MESSAGE_SIZE];
    if (read(shmid, read_message, MESSAGE_SIZE) == -1) {
        perror("read");
        return 1;
    }

    // Print the received message
    printf("Received message: %s\n", read_message);

    // Detach from the shared memory segment
    if (shmdt(shm) == -1) {
        perror("shmdt");
        return 1;
    }

    // Destroy the shared memory segment
    if (shmctl(shmid, IPC_RMID, 0) == -1) {
        perror("shmctl");
        return 1;
    }

    return 0;
}