//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 10
#define MAX_NAME_LEN 20
#define MAX_QUANTITY 100
#define MAX_PRICE 1000.00

typedef struct {
    char name[MAX_NAME_LEN];
    int quantity;
    double price;
} Stock;

void addStock(Stock* stocks, int numStocks, char* name, int quantity, double price) {
    if (numStocks >= MAX_STOCKS) {
        printf("Error: Maximum number of stocks reached.\n");
        return;
    }

    int i;
    for (i = 0; i < numStocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            printf("Error: Stock already exists.\n");
            return;
        }
    }

    strcpy(stocks[numStocks].name, name);
    stocks[numStocks].quantity = quantity;
    stocks[numStocks].price = price;

    numStocks++;
}

void updateStockQuantity(Stock* stocks, int numStocks, char* name, int quantity) {
    int i;
    for (i = 0; i < numStocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].quantity += quantity;
            break;
        }
    }
}

void updateStockPrice(Stock* stocks, int numStocks, char* name, double price) {
    int i;
    for (i = 0; i < numStocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].price = price;
            break;
        }
    }
}

void displayStocks(Stock* stocks, int numStocks) {
    printf("Stock Name\tQuantity\tPrice\n");

    int i;
    for (i = 0; i < numStocks; i++) {
        printf("%-20s\t%d\t%.2f\n", stocks[i].name, stocks[i].quantity, stocks[i].price);
    }
}

int main() {
    Stock stocks[MAX_STOCKS];
    int numStocks = 0;

    addStock(stocks, numStocks, "Apple", 100, 500.00);
    addStock(stocks, numStocks, "Google", 50, 1000.00);
    addStock(stocks, numStocks, "Microsoft", 75, 200.00);

    displayStocks(stocks, numStocks);

    updateStockQuantity(stocks, numStocks, "Apple", 25);
    updateStockPrice(stocks, numStocks, "Google", 1500.00);

    displayStocks(stocks, numStocks);

    return 0;
}