//GEMINI-pro DATASET v1.0 Category: Cryptography Implementation ; Style: all-encompassing
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 16

unsigned char key[KEY_SIZE] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};
unsigned char plaintext[BLOCK_SIZE] = {0x6B, 0xC1, 0xBE, 0xE2, 0x2E, 0x40, 0x9F, 0x96, 0xE9, 0x3D, 0x7E, 0x11, 0x73, 0x93, 0x17, 0x2A};
unsigned char ciphertext[BLOCK_SIZE];

void encrypt_block(unsigned char *plaintext, unsigned char *ciphertext) {
  int i;
  for (i = 0; i < BLOCK_SIZE; i++) {
    ciphertext[i] = plaintext[i] ^ key[i];
  }
}

void decrypt_block(unsigned char *ciphertext, unsigned char *plaintext) {
  int i;
  for (i = 0; i < BLOCK_SIZE; i++) {
    plaintext[i] = ciphertext[i] ^ key[i];
  }
}

int main() {
  int i;

  // Encrypt the plaintext block
  encrypt_block(plaintext, ciphertext);

  // Print the ciphertext block
  printf("Ciphertext: ");
  for (i = 0; i < BLOCK_SIZE; i++) {
    printf("%02X", ciphertext[i]);
  }
  printf("\n");

  // Decrypt the ciphertext block
  decrypt_block(ciphertext, plaintext);

  // Print the plaintext block
  printf("Plaintext: ");
  for (i = 0; i < BLOCK_SIZE; i++) {
    printf("%02X", plaintext[i]);
  }
  printf("\n");

  return 0;
}