//MISTRAL-7B DATASET v1.0 Category: Stock market tracker ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 100

typedef struct {
    char symbol[5];
    double price;
} Stock;

Stock stocks[MAX_STOCKS];
int num_stocks = 0;

void add_stock(const char* symbol, double price) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: Max number of stocks reached.\n");
        return;
    }

    strncpy(stocks[num_stocks].symbol, symbol, sizeof(stocks[num_stocks].symbol) - 1);
    stocks[num_stocks++].price = price;
}

void remove_stock(const char* symbol) {
    int i;

    for (i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].symbol, symbol) == 0) {
            for (int j = i; j < num_stocks - 1; j++) {
                stocks[j] = stocks[j + 1];
            }
            num_stocks--;
            break;
        }
    }
}

void display_stocks() {
    int i;

    printf("\nCurrent Stock Prices:\n");
    for (i = 0; i < num_stocks; i++) {
        printf("%s: %.2f\n", stocks[i].symbol, stocks[i].price);
    }
}

void update_stock_prices() {
    int i;

    printf("\nUpdating stock prices...\n");

    // Replace this with actual market data
    for (i = 0; i < num_stocks; i++) {
        stocks[i].price += 1.5; // Random increase in price
    }
}

int main() {
    add_stock("AAPL", 120.50);
    add_stock("GOOG", 156.25);
    add_stock("MSFT", 187.75);

    display_stocks();

    update_stock_prices();

    display_stocks();

    remove_stock("GOOG");

    display_stocks();

    return 0;
}