//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define PI 3.14159265

typedef struct {
  double x;
  double y;
} Point;

typedef struct {
  Point p1;
  Point p2;
} Line;

typedef struct {
  Point p;
  double r;
} Circle;

typedef enum {
  POINT,
  LINE,
  CIRCLE
} ShapeType;

typedef union {
  Point p;
  Line l;
  Circle c;
} Shape;

typedef struct {
  ShapeType type;
  Shape shape;
} WarehouseItem;

int main() {
  WarehouseItem items[] = {
    {POINT, {.p = {0, 0}}},
    {LINE, {.l = {{0, 0}, {1, 1}}}},
    {CIRCLE, {.c = {{0, 0}, 1}}}
  };

  for (int i = 0; i < sizeof(items) / sizeof(WarehouseItem); i++) {
    switch (items[i].type) {
      case POINT:
        printf("Point: (%f, %f)\n", items[i].shape.p.x, items[i].shape.p.y);
        break;
      case LINE:
        printf("Line: (%f, %f) -> (%f, %f)\n", items[i].shape.l.p1.x, items[i].shape.l.p1.y, items[i].shape.l.p2.x, items[i].shape.l.p2.y);
        break;
      case CIRCLE:
        printf("Circle: Center(%f, %f), Radius=%f\n", items[i].shape.c.p.x, items[i].shape.c.p.y, items[i].shape.c.r);
        break;
    }
  }

  return 0;
}