//Falcon-180B DATASET v1.0 Category: Appointment Scheduler ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_APPOINTMENTS 100
#define MAX_NAME_LENGTH 50
#define MAX_PHONE_LENGTH 20
#define MAX_EMAIL_LENGTH 100

// Struct to hold appointment information
typedef struct {
    char name[MAX_NAME_LENGTH];
    char phone[MAX_PHONE_LENGTH];
    char email[MAX_EMAIL_LENGTH];
    int appointment_time;
} Appointment;

// Function to add an appointment
void add_appointment(Appointment* appointments, int num_appointments, int new_appointment_time) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        printf("Sorry, the schedule is full.\n");
        return;
    }
    Appointment new_appointment = {
       .appointment_time = new_appointment_time
    };
    memcpy(&appointments[num_appointments], &new_appointment, sizeof(Appointment));
    num_appointments++;
}

// Function to remove an appointment
void remove_appointment(Appointment* appointments, int num_appointments, int appointment_time) {
    for (int i = 0; i < num_appointments; i++) {
        if (appointments[i].appointment_time == appointment_time) {
            memmove(&appointments[i], &appointments[i+1], sizeof(Appointment) * (num_appointments - i - 1));
            num_appointments--;
            return;
        }
    }
    printf("Sorry, that appointment does not exist.\n");
}

// Function to print the schedule
void print_schedule(Appointment* appointments, int num_appointments) {
    printf("Schedule:\n");
    for (int i = 0; i < num_appointments; i++) {
        printf("%s (%s) - %s\n", appointments[i].name, appointments[i].phone, appointments[i].email);
    }
}

// Main function
int main() {
    Appointment appointments[MAX_APPOINTMENTS];
    int num_appointments = 0;

    // Example usage
    add_appointment(appointments, num_appointments, 1200);
    add_appointment(appointments, num_appointments, 1330);
    add_appointment(appointments, num_appointments, 1500);

    print_schedule(appointments, num_appointments);

    remove_appointment(appointments, num_appointments, 1200);

    print_schedule(appointments, num_appointments);

    return 0;
}