//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather conditions
enum weather_condition {
    SUNNY,
    CLOUDY,
    RAINY,
    STORMY
};

// Define the weather data structure
struct weather {
    enum weather_condition condition;
    int temperature;
    int humidity;
    int wind_speed;
};

// Function to generate a random weather condition
enum weather_condition generate_weather_condition() {
    int random_number = rand() % 4;
    switch (random_number) {
        case 0:
            return SUNNY;
        case 1:
            return CLOUDY;
        case 2:
            return RAINY;
        case 3:
            return STORMY;
    }
}

// Function to generate a random temperature
int generate_temperature() {
    return rand() % 30 + 10;
}

// Function to generate a random humidity
int generate_humidity() {
    return rand() % 100;
}

// Function to generate a random wind speed
int generate_wind_speed() {
    return rand() % 10 + 1;
}

// Function to print the weather data
void print_weather(struct weather weather) {
    printf("The weather is currently %s.\n", weather.condition == SUNNY ? "sunny" : weather.condition == CLOUDY ? "cloudy" : weather.condition == RAINY ? "rainy" : "stormy");
    printf("The temperature is %d degrees Celsius.\n", weather.temperature);
    printf("The humidity is %d%%.\n", weather.humidity);
    printf("The wind speed is %d km/h.\n", weather.wind_speed);
}

// Main function
int main() {
    srand(time(NULL));

    // Generate a random weather condition
    enum weather_condition condition = generate_weather_condition();

    // Generate a random temperature
    int temperature = generate_temperature();

    // Generate a random humidity
    int humidity = generate_humidity();

    // Generate a random wind speed
    int wind_speed = generate_wind_speed();

    // Create a weather data structure
    struct weather weather = {
        .condition = condition,
        .temperature = temperature,
        .humidity = humidity,
        .wind_speed = wind_speed
    };

    // Print the weather data
    print_weather(weather);

    return 0;
}