//GEMINI-pro DATASET v1.0 Category: Syntax parsing ; Style: funny
#include <stdio.h>
#include <stdlib.h>

// Function to handle errors with laughter
void laugh_at_error(char *msg) {
    printf("hahahaha! Error: %s\n", msg);
    exit(1);
}

// Function to check if a character is a digit
int is_digit(char c) {
    return c >= '0' && c <= '9';
}

// Function to check if a character is a letter
int is_letter(char c) {
    return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z');
}

// Function to check if a character is a whitespace
int is_whitespace(char c) {
    return c == ' ' || c == '\n' || c == '\t';
}

// Function to check if a character is an operator
int is_operator(char c) {
    return c == '+' || c == '-' || c == '*' || c == '/' || c == '%';
}

// Function to check if a character is a parenthesis
int is_parenthesis(char c) {
    return c == '(' || c == ')';
}

// Function to check if a character is a semicolon
int is_semicolon(char c) {
    return c == ';';
}

// Function to check if a character is a quote
int is_quote(char c) {
    return c == '"' || c == '\'';
}

// Function to check if a character is valid
int is_valid_char(char c) {
    return is_digit(c) || is_letter(c) || is_whitespace(c) || is_operator(c) || is_parenthesis(c) || is_semicolon(c) || is_quote(c);
}

// Function to get the next token
int get_next_token(char *input, int *i) {
    // Skip whitespace
    while (is_whitespace(input[*i])) {
        (*i)++;
    }

    // Check for end of input
    if (input[*i] == '\0') {
        return -1;
    }

    // Check for digit
    if (is_digit(input[*i])) {
        return 1;
    }

    // Check for letter
    if (is_letter(input[*i])) {
        return 2;
    }

    // Check for operator
    if (is_operator(input[*i])) {
        return 3;
    }

    // Check for parenthesis
    if (is_parenthesis(input[*i])) {
        return 4;
    }

    // Check for semicolon
    if (is_semicolon(input[*i])) {
        return 5;
    }

    // Check for quote
    if (is_quote(input[*i])) {
        return 6;
    }

    // Invalid character
    laugh_at_error("Invalid character!");
    return -1;
}

// Function to parse the input
int parse_input(char *input) {
    int i = 0;
    int token;

    while ((token = get_next_token(input, &i)) != -1) {
        switch (token) {
            case 1:
                printf("Digit: %c\n", input[i]);
                break;
            case 2:
                printf("Letter: %c\n", input[i]);
                break;
            case 3:
                printf("Operator: %c\n", input[i]);
                break;
            case 4:
                printf("Parenthesis: %c\n", input[i]);
                break;
            case 5:
                printf("Semicolon: %c\n", input[i]);
                break;
            case 6:
                printf("Quote: %c\n", input[i]);
                break;
        }
        i++;
    }

    return 0;
}

// Main function
int main() {
    char input[] = "1 + 2 * 3; a = 4; \"Hello, world!\"";

    printf("Parsing input: %s\n", input);

    if (parse_input(input) == 0) {
        printf("Input parsed successfully!\n");
    } else {
        laugh_at_error("Input could not be parsed!");
    }

    return 0;
}