//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: invasive
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Our custom packet header */
struct custom_header {
    uint32_t magic_number;     /* Magic number to identify our packets */
    uint16_t packet_length;   /* Length of the packet in bytes */
    uint8_t data[1024];       /* Data payload of the packet */
};

/* Callback function to handle captured packets */
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    // Get the custom header from the packet
    struct custom_header *custom_header = (struct custom_header *)packet;

    // Check if the magic number matches our custom header
    if (custom_header->magic_number == 0x42424242) {
        // Process the packet data
        printf("Received custom packet with data: %s\n", custom_header->data);
    }
}

/* Main function */
int main(int argc, char **argv) {
    // Check if the user provided an interface name
    if (argc < 2) {
        printf("Usage: %s <interface>\n", argv[0]);
        return 1;
    }

    // Open the specified interface for capturing
    char *interface = argv[1];
    pcap_t *handle = pcap_open_live(interface, BUFSIZ, 1, 1000, NULL);
    if (handle == NULL) {
        fprintf(stderr, "Error opening interface %s\n", interface);
        return 1;
    }

    // Construct aBPF filter to only capture our custom packets
    struct bpf_program filter;
    char filter_expression[] = "tcp and port 12345";
    if (pcap_compile(handle, &filter, filter_expression, 0, 0) < 0) {
        fprintf(stderr, "Error compiling BPF filter\n");
        return 1;
    }

    // Set the filter on the capture handle
    if (pcap_setfilter(handle, &filter) < 0) {
        fprintf(stderr, "Error setting BPF filter\n");
        return 1;
    }

    // Start capturing packets
    pcap_loop(handle, -1, packet_handler, NULL);

    // Cleanup and exit
    pcap_close(handle);
    return 0;
}