//Falcon-180B DATASET v1.0 Category: Pathfinding algorithms ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#define INF (int)1e9
#define V 4

int dist[V][V];
int parent[V][V];

void dijkstra(int graph[V][V], int src) {
    int u, v, i, j, k, min_dist;

    for (i = 0; i < V; i++)
        dist[src][i] = graph[src][i];

    for (i = 0; i < V - 1; i++) {
        for (j = 0; j < V - 1; j++) {
            for (k = 0; k < V - 1; k++) {
                if (dist[j][k] > dist[j][i] + dist[i][k]) {
                    dist[j][k] = dist[j][i] + dist[i][k];
                    parent[j][k] = i;
                }
            }
        }
    }

    for (i = 0; i < V - 1; i++) {
        min_dist = INF;
        u = -1;
        for (j = 0; j < V - 1; j++) {
            if (dist[i][j] < min_dist) {
                min_dist = dist[i][j];
                u = j;
            }
        }
        v = parent[i][u];
        printf("%d <- %d \n", u, v);
    }
}

int main() {
    int graph[V][V] = {{0, 4, INF, 8},
                      {INF, 0, 8, 2},
                      {INF, INF, 0, 1},
                      {INF, INF, INF, 0}};

    int src = 0;
    dijkstra(graph, src);

    return 0;
}