//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>
#include <string.h>

void print_shape(const char *shape) {
    printf("\nShape Shifter: \n");
    if (strcmp(shape, "circle") == 0) {
        printf("    *    \n");
        printf(" *   * \n");
        printf("*      *\n");
        printf(" *   * \n");
        printf("    *    \n");
    } else if (strcmp(shape, "square") == 0) {
        printf("********\n");
        printf("*      *\n");
        printf("*      *\n");
        printf("********\n");
    } else if (strcmp(shape, "triangle") == 0) {
        printf("   /\\   \n");
        printf("  /  \\  \n");
        printf(" /____\\ \n");
    } else {
        printf("Unknown shape! It's an amorphous blob.\n");
    }
}

int callback(void *not_used, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i] ? azColName[i] : "NULL", argv[i] ? argv[i] : "NULL");
    }
    return 0;
}

int fetch_shape(sqlite3 *db) {
    const char *sql = "SELECT shape FROM Shapes ORDER BY RANDOM() LIMIT 1;";
    char *err_msg = 0;

    int rc = sqlite3_exec(db, sql, callback, 0, &err_msg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
        return 0;
    }
    return 1;
}

int create_table(sqlite3 *db) {
    const char *sql = "CREATE TABLE IF NOT EXISTS Shapes (Id INTEGER PRIMARY KEY, shape TEXT);";
    char *err_msg = 0;
    
    int rc = sqlite3_exec(db, sql, 0, 0, &err_msg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
        return 0;
    }
    return 1;
}

int insert_shapes(sqlite3 *db) {
    const char *shapes[] = {"circle", "square", "triangle"};
    char sql[256];
    char *err_msg = 0;

    for (int i = 0; i < 3; i++) {
        snprintf(sql, sizeof(sql), "INSERT INTO Shapes (shape) VALUES ('%s');", shapes[i]);
        int rc = sqlite3_exec(db, sql, 0, 0, &err_msg);
        if (rc != SQLITE_OK) {
            fprintf(stderr, "SQL error: %s\n", err_msg);
            sqlite3_free(err_msg);
            return 0;
        }
    }
    return 1;
}

int main() {
    sqlite3 *db;
    int rc = sqlite3_open("shapes.db", &db);
    
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return EXIT_FAILURE;
    }

    if (!create_table(db)) {
        sqlite3_close(db);
        return EXIT_FAILURE;
    }

    if (!insert_shapes(db)) {
        sqlite3_close(db);
        return EXIT_FAILURE;
    }

    printf("Fetching a random shape from the Shapes table:\n");
    
    if (fetch_shape(db)) {
        printf("Shape fetched successfully! Time to shape shift...\n");
        print_shape("circle"); // This can be changed based on the fetched shape
    }

    sqlite3_close(db);
    return EXIT_SUCCESS;
}