//Falcon-180B DATASET v1.0 Category: Firewall ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_RULE_NUM 100
#define MAX_RULE_LEN 100
#define MAX_IP_LEN 16

typedef struct {
    char ip[MAX_IP_LEN];
    int port;
} ip_port;

typedef struct {
    char action[10];
    ip_port source;
    ip_port destination;
} rule;

int load_rules(rule rules[], int num) {
    FILE *fp = fopen("firewall_rules.txt", "r");
    if (fp == NULL) {
        printf("Error: Cannot open firewall_rules.txt\n");
        exit(1);
    }

    int count = 0;
    while (fscanf(fp, "%s %s %d:%d %s %d:%d\n", rules[count].action, rules[count].source.ip, &rules[count].source.port, &rules[count].destination.port, rules[count].destination.ip, &rules[count].destination.port)!= EOF) {
        count++;
        if (count >= num) {
            break;
        }
    }

    fclose(fp);
    return count;
}

int compare_ip(const void *a, const void *b) {
    ip_port *ip1 = (ip_port *)a;
    ip_port *ip2 = (ip_port *)b;

    return strcmp(ip1->ip, ip2->ip);
}

int compare_port(const void *a, const void *b) {
    ip_port *port1 = (ip_port *)a;
    ip_port *port2 = (ip_port *)b;

    return port1->port - port2->port;
}

void sort_rules(rule rules[], int num) {
    qsort(rules, num, sizeof(rule), compare_ip);
}

int main() {
    rule rules[MAX_RULE_NUM];
    int num_rules = load_rules(rules, MAX_RULE_NUM);

    sort_rules(rules, num_rules);

    printf("Firewall rules:\n");
    for (int i = 0; i < num_rules; i++) {
        printf("%s %s:%d -> %s:%d\n", rules[i].action, rules[i].source.ip, rules[i].source.port, rules[i].destination.ip, rules[i].destination.port);
    }

    return 0;
}