//Falcon2-11B DATASET v1.0 Category: Interprocess communication ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <unistd.h>

#define MAX_BUFFER_SIZE 1024

void* receive_data(int client_socket, char* buffer, int size) {
    int bytes_read = recv(client_socket, buffer, size, 0);
    if (bytes_read < 0) {
        perror("recv");
    } else {
        printf("Received %d bytes of data\n", bytes_read);
    }
    return NULL;
}

void* send_data(int client_socket, const char* message, int size) {
    int bytes_sent = send(client_socket, message, size, 0);
    if (bytes_sent < 0) {
        perror("send");
    } else {
        printf("Sent %d bytes of data\n", bytes_sent);
    }
    return NULL;
}

int main() {
    int server_socket_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (server_socket_fd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    struct sockaddr_in server_addr;
    bzero((char*) &server_addr, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    server_addr.sin_port = htons(8080);

    if (bind(server_socket_fd, (struct sockaddr*) &server_addr, sizeof(server_addr)) == -1) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    if (listen(server_socket_fd, 5) == -1) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    printf("Waiting for client connection...\n");
    int client_socket_fd = accept(server_socket_fd, NULL, NULL);
    if (client_socket_fd == -1) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    printf("Client connected, sending data...\n");
    char message[MAX_BUFFER_SIZE];
    bzero(message, sizeof(message));
    send_data(client_socket_fd, message, sizeof(message));

    printf("Receiving data from client...\n");
    char buffer[MAX_BUFFER_SIZE];
    bzero(buffer, sizeof(buffer));
    receive_data(client_socket_fd, buffer, sizeof(buffer));
    printf("%s", buffer);

    printf("Closing client connection...\n");
    close(client_socket_fd);

    printf("Server socket closed, exiting...\n");
    close(server_socket_fd);

    return 0;
}