//Falcon-180B DATASET v1.0 Category: Rogue-like Game with Procedural Generation ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_ROOMS 100
#define MAX_ROOM_SIZE 20
#define MAX_ROOM_ITEMS 10
#define MAX_ROOM_ENEMIES 5

typedef struct {
    int x, y;
} Room;

typedef struct {
    char name[20];
    int value;
} Item;

typedef struct {
    char name[20];
    int health;
    int attack;
} Enemy;

int num_rooms = 0;
Room rooms[MAX_ROOMS];
Item items[MAX_ROOM_ITEMS];
Enemy enemies[MAX_ROOM_ENEMIES];

void generate_room(int x, int y) {
    Room new_room = {x, y};
    rooms[num_rooms++] = new_room;
}

void generate_items() {
    for (int i = 0; i < num_rooms; i++) {
        int num_items = rand() % MAX_ROOM_ITEMS + 1;
        for (int j = 0; j < num_items; j++) {
            Item new_item = {"Item", rand() % 100};
            items[i * MAX_ROOM_ITEMS + j] = new_item;
        }
    }
}

void generate_enemies() {
    for (int i = 0; i < num_rooms; i++) {
        int num_enemies = rand() % MAX_ROOM_ENEMIES + 1;
        for (int j = 0; j < num_enemies; j++) {
            Enemy new_enemy = {"Enemy", rand() % 100, rand() % 50};
            enemies[i * MAX_ROOM_ENEMIES + j] = new_enemy;
        }
    }
}

int main() {
    srand(time(NULL));

    generate_room(0, 0);

    generate_items();

    generate_enemies();

    return 0;
}