//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS 7

typedef enum {
    SUNNY,
    CLOUDY,
    RAINY,
    STORMY
} WeatherType;

const char *weatherTypeNames[] = {
    "Sunny",
    "Cloudy",
    "Rainy",
    "Stormy"
};

typedef struct {
    int day;
    WeatherType weather;
    float temperature; // In Celsius
} DayWeather;

DayWeather createDayWeather(int day) {
    DayWeather dayWeather;
    dayWeather.day = day;
    
    // Randomly generate weather
    dayWeather.weather = rand() % 4; // 0 to 3
    // Random temperature between -10 and 35
    dayWeather.temperature = (float)(rand() % 461) / 10.0 - 10; // Converted to -10 to 35 range

    return dayWeather;
}

void displayWeatherForecast(DayWeather weekWeather[]) {
    printf("Weather Forecast for the Week:\n");

    for (int i = 0; i < DAYS; i++) {
        printf("Day %d: %s, Temperature: %.1f°C\n", 
               weekWeather[i].day, 
               weatherTypeNames[weekWeather[i].weather], 
               weekWeather[i].temperature);
    }
}

void simulateWeatherForecast() {
    DayWeather weekWeather[DAYS];

    // Seed the random number generator
    srand(time(NULL));

    // Generate weather for each day
    for (int i = 0; i < DAYS; i++) {
        weekWeather[i] = createDayWeather(i + 1);
    }

    // Display the generated weather forecast
    displayWeatherForecast(weekWeather);
}

void suggestActivities(WeatherType weather) {
    switch (weather) {
        case SUNNY:
            printf("Suggested Activity: Go for a hike or picnic!\n");
            break;
        case CLOUDY:
            printf("Suggested Activity: Visit a museum or go shopping.\n");
            break;
        case RAINY:
            printf("Suggested Activity: Stay in and watch a movie or read a book.\n");
            break;
        case STORMY:
            printf("Suggested Activity: It's best to stay indoors and stay safe!\n");
            break;
        default:
            printf("Unknown weather type!\n");
    }
}

void encourageActivity(DayWeather weekWeather[]) {
    printf("\nSuggested Activities for the Week:\n");
    for (int i = 0; i < DAYS; i++) {
        printf("On Day %d (%s): ", weekWeather[i].day, weatherTypeNames[weekWeather[i].weather]);
        suggestActivities(weekWeather[i].weather);
    }
}

int main() {
    simulateWeatherForecast();
    return 0;
}