//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

#define AES_BLOCK_SIZE 16

void handleErrors() {
    fprintf(stderr, "Error occurred.\n");
    exit(EXIT_FAILURE);
}

void generate_key(unsigned char *key, int key_size) {
    if (!RAND_bytes(key, key_size)) {
        handleErrors();
    }
}

void aes_encrypt(unsigned char *input, unsigned char *output, unsigned char *key, int key_size) {
    AES_KEY encryptKey;
    if (AES_set_encrypt_key(key, key_size * 8, &encryptKey) < 0) {
        handleErrors();
    }
    AES_encrypt(input, output, &encryptKey);
}

void aes_decrypt(unsigned char *input, unsigned char *output, unsigned char *key, int key_size) {
    AES_KEY decryptKey;
    if (AES_set_decrypt_key(key, key_size * 8, &decryptKey) < 0) {
        handleErrors();
    }
    AES_decrypt(input, output, &decryptKey);
}

void print_bytes(unsigned char *data, int length) {
    for (int i = 0; i < length; i++) {
        printf("%02x", data[i]);
    }
    printf("\n");
}

int main() {
    // Configuration variables
    const int key_size = 16; // 16 bytes for AES-128
    unsigned char key[AES_BLOCK_SIZE]; // Key buffer
    unsigned char input[AES_BLOCK_SIZE]; // Input buffer
    unsigned char output[AES_BLOCK_SIZE]; // Output buffer

    // Generate a key
    generate_key(key, key_size);
    printf("Generated AES key: ");
    print_bytes(key, key_size);

    // Get input from the user
    printf("Enter 16 bytes (hex) to encrypt: ");
    char input_hex[33];  // 32 hex digits + 1 null terminator
    scanf("%32s", input_hex);

    // Convert hex input to byte array
    for (int i = 0; i < 16; i++) {
        sscanf(input_hex + 2*i, "%2hhx", &input[i]);
    }

    // Encrypt the input
    aes_encrypt(input, output, key, key_size);
    printf("Encrypted output (hex): ");
    print_bytes(output, AES_BLOCK_SIZE);

    // Decrypt the output
    unsigned char decrypted[AES_BLOCK_SIZE];
    aes_decrypt(output, decrypted, key, key_size);
    printf("Decrypted output (hex): ");
    print_bytes(decrypted, AES_BLOCK_SIZE);

    return 0;
}