//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 10
#define HEIGHT 10

// Define colors using ANSI escape codes
#define RESET "\x1b[0m"
#define RED "\x1b[31m"
#define GREEN "\x1b[32m"
#define BLUE "\x1b[34m"
#define YELLOW "\x1b[33m"
#define CYAN "\x1b[36m"
#define MAGENTA "\x1b[35m"

// Pixel structure
typedef struct {
    char character;
    const char *color;
} Pixel;

// Function prototypes
void initializeCanvas(Pixel canvas[HEIGHT][WIDTH]);
void displayCanvas(Pixel canvas[HEIGHT][WIDTH]);
void setPixel(Pixel canvas[HEIGHT][WIDTH], int x, int y, const char *color, char character);
void clearCanvas(Pixel canvas[HEIGHT][WIDTH]);

int main() {
    Pixel canvas[HEIGHT][WIDTH];
    int x, y;
    char character;
    int choice;

    // Initialize canvas
    initializeCanvas(canvas);

    // Interactive loop
    while (1) {
        displayCanvas(canvas);
        printf("Choose a color to set a pixel (1: Red, 2: Green, 3: Blue, 4: Yellow, 5: Cyan, 6: Magenta, 0: Exit): ");
        scanf("%d", &choice);
        
        if (choice == 0) {
            break;
        }

        printf("Enter coordinates (x y) [0-%d]: ", WIDTH - 1);
        scanf("%d %d", &x, &y);
        if (x < 0 || x >= WIDTH || y < 0 || y >= HEIGHT) {
            printf("Invalid coordinates!\n");
            continue;
        }
        
        printf("Enter character to draw: ");
        scanf(" %c", &character);

        const char *color;
        switch (choice) {
            case 1: color = RED; break;
            case 2: color = GREEN; break;
            case 3: color = BLUE; break;
            case 4: color = YELLOW; break;
            case 5: color = CYAN; break;
            case 6: color = MAGENTA; break;
            default: color = RESET; break;
        }
        
        setPixel(canvas, x, y, color, character);
    }

    return 0;
}

void initializeCanvas(Pixel canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            canvas[y][x].character = ' ';
            canvas[y][x].color = RESET; // Reset color
        }
    }
}

void displayCanvas(Pixel canvas[HEIGHT][WIDTH]) {
    system("clear"); // Clear the terminal
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            printf("%s%c%s ", canvas[y][x].color, canvas[y][x].character, RESET);
        }
        printf("\n");
    }
}

void setPixel(Pixel canvas[HEIGHT][WIDTH], int x, int y, const char *color, char character) {
    canvas[y][x].color = color;
    canvas[y][x].character = character;
}

void clearCanvas(Pixel canvas[HEIGHT][WIDTH]) {
    initializeCanvas(canvas);
}