//Falcon2-11B DATASET v1.0 Category: Building a HTTP Client ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <unistd.h>

// Function to create a TCP socket
int create_socket(int port) {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(1);
    }
    return sockfd;
}

// Function to connect to the server
int connect_to_server(int sockfd, struct sockaddr_in server_addr) {
    int connected = 1;
    if (connect(sockfd, (struct sockaddr*)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect");
        exit(1);
    }
    return connected;
}

// Function to send data to the server
int send_data(int sockfd, char* message, int length) {
    int sent = 0;
    if (send(sockfd, message, length, 0) < 0) {
        perror("send");
        exit(1);
    }
    return sent;
}

// Function to receive data from the server
int receive_data(int sockfd, char* buffer, int length) {
    int received = 0;
    if (recv(sockfd, buffer, length, 0) < 0) {
        perror("recv");
        exit(1);
    }
    return received;
}

// Function to close the socket
void close_socket(int sockfd) {
    if (close(sockfd) < 0) {
        perror("close");
    }
}

int main() {
    int sockfd;
    struct sockaddr_in server_addr;
    int port = 80;
    char buffer[1024];

    sockfd = create_socket(port);
    if (sockfd == -1) {
        perror("create_socket");
        exit(1);
    }

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    server_addr.sin_addr.s_addr = INADDR_ANY;

    connect_to_server(sockfd, server_addr);

    char message[] = "GET / HTTP/1.1\r\n\r\n";
    int length = sizeof(message);
    if (send_data(sockfd, message, length) == -1) {
        perror("send_data");
        exit(1);
    }

    int received = 0;
    if (receive_data(sockfd, buffer, sizeof(buffer)) == -1) {
        perror("receive_data");
        exit(1);
    }

    printf("Received: %s\n", buffer);

    close_socket(sockfd);

    return 0;
}