//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 20
#define MAX_FILE_CONTENT_LENGTH 100

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char content[MAX_FILE_CONTENT_LENGTH];
} File;

File files[MAX_FILES];
int num_files;

void init() {
    num_files = 0;
}

int create_file(char* name, char* content) {
    if (num_files >= MAX_FILES) {
        printf("Error: Maximum number of files reached.\n");
        return -1;
    }

    strcpy(files[num_files].name, name);
    strcpy(files[num_files].content, content);
    num_files++;

    return 0;
}

int read_file(char* name) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File content: %s\n", files[i].content);
            return 0;
        }
    }

    printf("Error: File not found.\n");
    return -1;
}

int write_file(char* name, char* content) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].content, content);
            printf("File updated.\n");
            return 0;
        }
    }

    printf("Error: File not found.\n");
    return -1;
}

int delete_file(char* name) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(&files[i], 0, sizeof(File));
            printf("File deleted.\n");
            return 0;
        }
    }

    printf("Error: File not found.\n");
    return -1;
}

int main() {
    init();

    create_file("test.txt", "Hello, world!");
    read_file("test.txt");
    write_file("test.txt", "Hello, C language!");
    read_file("test.txt");
    delete_file("test.txt");
    read_file("test.txt");

    return 0;
}