//GEMINI-pro DATASET v1.0 Category: Expense Tracker ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EXPENSES 100
#define MAX_EXPENSE_DESC_LEN 100

typedef struct {
  char desc[MAX_EXPENSE_DESC_LEN];
  float amount;
  int day;
  int month;
  int year;
} Expense;

Expense expenses[MAX_EXPENSES];
int num_expenses = 0;

void add_expense(char *desc, float amount, int day, int month, int year) {
  if (num_expenses >= MAX_EXPENSES) {
    fprintf(stderr, "Error: Too many expenses. Max: %d\n", MAX_EXPENSES);
    return;
  }

  strcpy(expenses[num_expenses].desc, desc);
  expenses[num_expenses].amount = amount;
  expenses[num_expenses].day = day;
  expenses[num_expenses].month = month;
  expenses[num_expenses].year = year;
  num_expenses++;
}

void print_expenses() {
  printf("Expenses:\n");
  for (int i = 0; i < num_expenses; i++) {
    printf("%s: $%.2f (%d/%d/%d)\n", expenses[i].desc, expenses[i].amount, expenses[i].day, expenses[i].month, expenses[i].year);
  }
}

void sort_expenses_by_amount() {
  for (int i = 0; i < num_expenses - 1; i++) {
    for (int j = 0; j < num_expenses - i - 1; j++) {
      if (expenses[j].amount > expenses[j + 1].amount) {
        Expense temp = expenses[j];
        expenses[j] = expenses[j + 1];
        expenses[j + 1] = temp;
      }
    }
  }
}

void sort_expenses_by_date() {
  for (int i = 0; i < num_expenses - 1; i++) {
    for (int j = 0; j < num_expenses - i - 1; j++) {
      if (expenses[j].year > expenses[j + 1].year ||
          (expenses[j].year == expenses[j + 1].year && expenses[j].month > expenses[j + 1].month) ||
          (expenses[j].year == expenses[j + 1].year && expenses[j].month == expenses[j + 1].month && expenses[j].day > expenses[j + 1].day)) {
        Expense temp = expenses[j];
        expenses[j] = expenses[j + 1];
        expenses[j + 1] = temp;
      }
    }
  }
}

int main() {
  add_expense("Rent", 1000.00, 1, 1, 2023);
  add_expense("Groceries", 200.00, 5, 1, 2023);
  add_expense("Gas", 50.00, 10, 1, 2023);
  add_expense("Entertainment", 100.00, 15, 1, 2023);
  add_expense("Other", 50.00, 20, 1, 2023);

  print_expenses();

  sort_expenses_by_amount();
  printf("\nExpenses sorted by amount:\n");
  print_expenses();

  sort_expenses_by_date();
  printf("\nExpenses sorted by date:\n");
  print_expenses();

  return 0;
}