//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: cheerful
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Definition of the phone book structure
typedef struct {
    char name[50];    // Name of the person
    char number[20];  // Phone number of the person
} phone_book;

// Function to initialize the phone book
void init_phone_book(phone_book *phone_book_arr) {
    int i;
    for (i = 0; i < 10; i++) {
        phone_book_arr[i].name[0] = '\0';
        phone_book_arr[i].number[0] = '\0';
    }
}

// Function to add a new entry to the phone book
void add_entry(phone_book *phone_book_arr, char *name, char *number) {
    int i;
    for (i = 0; i < 10; i++) {
        if (strcmp(phone_book_arr[i].name, name) == 0) {
            strcpy(phone_book_arr[i].number, number);
            break;
        }
    }
    if (i == 10) {
        printf("Phone book is full! Can't add any more entries.\n");
    }
}

// Function to search for a name in the phone book
char *search_name(phone_book *phone_book_arr, char *name) {
    int i;
    for (i = 0; i < 10; i++) {
        if (strcmp(phone_book_arr[i].name, name) == 0) {
            return phone_book_arr[i].number;
        }
    }
    return NULL;
}

// Function to display the phone book
void display_phone_book(phone_book *phone_book_arr) {
    int i;
    for (i = 0; i < 10; i++) {
        printf("%d. %s %s\n", i + 1, phone_book_arr[i].name, phone_book_arr[i].number);
    }
}

int main() {
    phone_book phone_book_arr[10];

    // Initialize the phone book
    init_phone_book(phone_book_arr);

    // Add some entries to the phone book
    add_entry(phone_book_arr, "John Doe", "555-1234");
    add_entry(phone_book_arr, "Jane Doe", "555-5678");
    add_entry(phone_book_arr, "Bob Smith", "555-9012");

    // Search for a name in the phone book
    char *number = search_name(phone_book_arr, "Jane Doe");
    if (number != NULL) {
        printf("Jane Doe's phone number is: %s\n", number);
    } else {
        printf("Jane Doe is not in the phone book.\n");
    }

    // Display the phone book
    display_phone_book(phone_book_arr);

    return 0;
}