//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: invasive
#include <stdio.h>
#include <stdlib.h>

#define MAX_COINS 6

// Function to find the maximum value using greedy algorithm
void findMaxValue(int coins[], int n) {
    int max_value = 0;
    for (int i = 0; i < n; i++) {
        if (coins[i] > max_value) {
            max_value = coins[i];
        }
    }
    printf("The maximum value is: %d\n", max_value);
}

// Function to find the minimum number of coins required to make a given value
void findMinCoins(int coins[], int n, int value) {
    int min_coins = 0;
    for (int i = 0; i < n; i++) {
        if (coins[i] <= value) {
            min_coins++;
        }
    }
    printf("The minimum number of coins required is: %d\n", min_coins);
}

// Function to find the maximum value using greedy algorithm with minimum coins
void findMaxValueWithMinCoins(int coins[], int n, int value) {
    int max_value = 0;
    int min_coins = 0;
    for (int i = 0; i < n; i++) {
        if (coins[i] > max_value) {
            max_value = coins[i];
            min_coins = 1;
        } else if (coins[i] == max_value) {
            min_coins++;
        }
    }
    printf("The maximum value with minimum coins is: %d\n", max_value);
    printf("The minimum number of coins required is: %d\n", min_coins);
}

// Main function
int main() {
    int coins[] = {1, 5, 10, 25, 50, 100};
    int n = sizeof(coins)/sizeof(coins[0]);
    int value = 63;

    // Find the maximum value using greedy algorithm
    findMaxValue(coins, n);

    // Find the minimum number of coins required to make a given value
    findMinCoins(coins, n, value);

    // Find the maximum value using greedy algorithm with minimum coins
    findMaxValueWithMinCoins(coins, n, value);

    return 0;
}