//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 30
#define HEIGHT 15

// Define pixel colors
#define COLOR_RESET "\033[0m"
#define COLOR_YELLOW "\033[1;33m"
#define COLOR_BLACK "\033[1;30m"
#define COLOR_BLUE "\033[1;34m"

// Function to initialize the pixel grid
void initializeGrid(char grid[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            grid[y][x] = ' '; // Fill with spaces initially
        }
    }
}

// Function to draw the happy face
void drawHappyFace(char grid[HEIGHT][WIDTH]) {
    // Draw the face
    for (int y = 3; y < 12; y++) {
        for (int x = 6; x < 24; x++) {
            if (y == 4 || y == 9) {
                if (x < 11 || x > 20) {
                    grid[y][x] = COLOR_YELLOW[0]; // Left and right borders
                } else {
                    grid[y][x] = COLOR_RESET[0]; // Clear the inside
                }
            }
            else if (y == 5 || y == 6 || y == 7 || y == 8) {
                grid[y][x] = COLOR_YELLOW[0]; // Draw the face
            }
        }
    }

    // Draw the eyes
    grid[6][10] = COLOR_BLACK[0]; // Left eye
    grid[6][18] = COLOR_BLACK[0]; // Right eye

    // Draw the mouth
    grid[8][12] = COLOR_BLUE[0]; // Mouth start
    grid[8][13] = COLOR_BLUE[0]; // Mouth middle
    grid[8][14] = COLOR_BLUE[0]; // Mouth end
    grid[9][11] = COLOR_BLUE[0]; // Mouth down left
    grid[9][15] = COLOR_BLUE[0]; // Mouth down right
}

// Function to display the grid
void displayGrid(char grid[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            if (grid[y][x] == COLOR_YELLOW[0])
                printf(COLOR_YELLOW "  " COLOR_RESET); // Face color
            else if (grid[y][x] == COLOR_BLACK[0])
                printf(COLOR_BLACK "  " COLOR_RESET); // Eye color
            else if (grid[y][x] == COLOR_BLUE[0])
                printf(COLOR_BLUE "  " COLOR_RESET); // Mouth color
            else
                printf("  "); // Empty space
        }
        printf("\n");
    }
}

int main() {
    char grid[HEIGHT][WIDTH];

    // Initialize the random seed
    srand(time(NULL));

    // Initialize, draw and display the pixel art
    initializeGrid(grid);
    drawHappyFace(grid);
    displayGrid(grid);

    printf("\nEnjoy your happy face pixel art!\n");

    return 0;
}