//GEMINI-pro DATASET v1.0 Category: Movie Rating System ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_MOVIES 10
#define MIN_RATING 0.0
#define MAX_RATING 10.0

typedef struct {
    char title[100];
    int year;
    float rating;
} Movie;

void print_movie(Movie movie) {
    printf("Title: %s\n", movie.title);
    printf("Year: %d\n", movie.year);
    printf("Rating: %.1f\n", movie.rating);
    printf("\n");
}

void print_movies(Movie movies[], int num_movies) {
    for (int i = 0; i < num_movies; i++) {
        print_movie(movies[i]);
    }
}

int compare_movies(const void *a, const void *b) {
    Movie *movie1 = (Movie *)a;
    Movie *movie2 = (Movie *)b;

    return strcmp(movie1->title, movie2->title);
}

int main() {
    // Create an array of movies
    Movie movies[] = {
        {"The Shawshank Redemption", 1994, 9.3},
        {"The Godfather", 1972, 9.2},
        {"The Dark Knight", 2008, 9.0},
        {"12 Angry Men", 1957, 9.0},
        {"Schindler's List", 1993, 9.0},
        {"Pulp Fiction", 1994, 8.9},
        {"The Lord of the Rings: The Return of the King", 2003, 8.9},
        {"The Good, the Bad and the Ugly", 1966, 8.8},
        {"Forrest Gump", 1994, 8.8},
        {"The Matrix", 1999, 8.7}
    };

    // Sort the movies by title
    qsort(movies, MAX_MOVIES, sizeof(Movie), compare_movies);

    // Print the sorted movies
    print_movies(movies, MAX_MOVIES);

    return 0;
}