//Gemma-7B DATASET v1.0 Category: Simulation of the Solar System ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>

#define NUM_PLANETS 8

typedef struct Planet {
  char name[20];
  double mass, distance, speed;
  int color;
} Planet;

Planet planets[NUM_PLANETS] = {
  {"Sun", 998000, 0, 0, 0},
  {"Mercury", 0.055, 59.2, 48, 1},
  {"Venus", 0.815, 67.2, 36, 2},
  {"Earth", 1.0, 93.0, 29.7, 3},
  {"Mars", 0.643, 248.2, 24, 4},
  {"Jupiter", 530, 520.0, 13.8, 5},
  {"Saturn", 95, 886.0, 9.6, 6},
  {"Uranus", 14.5, 2.825, 6.8, 7}
};

void draw_planets() {
  for (int i = 0; i < NUM_PLANETS; i++) {
    switch (planets[i].color) {
      case 0:
        printf("  %s (yellow)\n", planets[i].name);
        break;
      case 1:
        printf("  %s (red)\n", planets[i].name);
        break;
      case 2:
        printf("  %s (orange)\n", planets[i].name);
        break;
      case 3:
        printf("  %s (green)\n", planets[i].name);
        break;
      case 4:
        printf("  %s (brown)\n", planets[i].name);
        break;
      case 5:
        printf("  %s (grey)\n", planets[i].name);
        break;
      case 6:
        printf("  %s (blue)\n", planets[i].name);
        break;
      case 7:
        printf("  %s (purple)\n", planets[i].name);
        break;
    }
  }
}

int main() {
  draw_planets();
  return 0;
}