//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_USERS 100
#define MAX_ACTIVITIES 100
#define MAX_STATISTICS 10

typedef struct {
    char name[50];
    int age;
    float weight;
    int user_id;
} User;

typedef struct {
    char name[50];
    int calories_burned;
    User* user;
} Activity;

typedef struct {
    char name[50];
    float value;
    time_t timestamp;
    User* user;
} Statistic;

int num_users = 0;
User users[MAX_USERS];

int num_activities = 0;
Activity activities[MAX_ACTIVITIES];

int num_statistics = 0;
Statistic statistics[MAX_STATISTICS];

void add_user(char* name, int age, float weight) {
    User user;
    strcpy(user.name, name);
    user.age = age;
    user.weight = weight;
    user.user_id = num_users;
    users[num_users] = user;
    num_users++;
}

int get_user_id(char* name) {
    for (int i = 0; i < num_users; i++) {
        if (strcmp(name, users[i].name) == 0) {
            return users[i].user_id;
        }
    }
    return -1;
}

void add_activity(char* name, int calories_burned, User* user) {
    Activity activity;
    strcpy(activity.name, name);
    activity.calories_burned = calories_burned;
    activity.user = user;
    activities[num_activities] = activity;
    num_activities++;
}

void add_statistic(char* name, float value, User* user) {
    Statistic statistic;
    strcpy(statistic.name, name);
    statistic.value = value;
    statistic.timestamp = time(NULL);
    statistic.user = user;
    statistics[num_statistics] = statistic;
    num_statistics++;
}

void print_users() {
    printf("Users:\n");
    for (int i = 0; i < num_users; i++) {
        printf("%d. %s (%d years old, %.2f kg)\n", i+1, users[i].name, users[i].age, users[i].weight);
    }
}

void print_activities() {
    printf("\nActivities:\n");
    for (int i = 0; i < num_activities; i++) {
        printf("%d. %s (%.0f calories burned)\n", i+1, activities[i].name, activities[i].calories_burned);
    }
}

void print_statistics() {
    printf("\nStatistics:\n");
    for (int i = 0; i < num_statistics; i++) {
        printf("%d. %s: %.2f (%.0f calories burned)\n", i+1, statistics[i].name, statistics[i].value, statistics[i].value*statistics[i].user->weight/100);
    }
}

int main() {
    add_user("John", 25, 80.0);
    add_user("Jane", 30, 65.0);
    add_activity("Running", 500, &users[0]);
    add_activity("Swimming", 300, &users[1]);
    add_statistic("Push-ups", 20.0, &users[0]);
    add_statistic("Sit-ups", 30.0, &users[1]);

    print_users();
    print_activities();
    print_statistics();

    return 0;
}