//GEMINI-pro DATASET v1.0 Category: Building a SMTP Client ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
  int sockfd;
  struct sockaddr_in servaddr;

  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    perror("socket");
    exit(1);
  }

  // Specify the server address
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(25);
  servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

  // Connect to the server
  if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
    perror("connect");
    exit(1);
  }

  // Send the HELO command
  char *helo = "HELO localhost\r\n";
  if (send(sockfd, helo, strlen(helo), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Receive the server response
  char recvbuf[4096];
  int nbytes = recv(sockfd, recvbuf, sizeof(recvbuf), 0);
  if (nbytes == -1) {
    perror("recv");
    exit(1);
  }

  // Print the server response
  printf("%s", recvbuf);

  // Send the MAIL FROM command
  char *mail_from = "MAIL FROM: <sender@example.com>\r\n";
  if (send(sockfd, mail_from, strlen(mail_from), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Receive the server response
  nbytes = recv(sockfd, recvbuf, sizeof(recvbuf), 0);
  if (nbytes == -1) {
    perror("recv");
    exit(1);
  }

  // Print the server response
  printf("%s", recvbuf);

  // Send the RCPT TO command
  char *rcpt_to = "RCPT TO: <recipient@example.com>\r\n";
  if (send(sockfd, rcpt_to, strlen(rcpt_to), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Receive the server response
  nbytes = recv(sockfd, recvbuf, sizeof(recvbuf), 0);
  if (nbytes == -1) {
    perror("recv");
    exit(1);
  }

  // Print the server response
  printf("%s", recvbuf);

  // Send the DATA command
  char *data = "DATA\r\n";
  if (send(sockfd, data, strlen(data), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Receive the server response
  nbytes = recv(sockfd, recvbuf, sizeof(recvbuf), 0);
  if (nbytes == -1) {
    perror("recv");
    exit(1);
  }

  // Print the server response
  printf("%s", recvbuf);

  // Send the email message
  char *message = "This is a test email message.\r\n";
  if (send(sockfd, message, strlen(message), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Send the dot command to indicate the end of the message
  char *dot = ".\r\n";
  if (send(sockfd, dot, strlen(dot), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Receive the server response
  nbytes = recv(sockfd, recvbuf, sizeof(recvbuf), 0);
  if (nbytes == -1) {
    perror("recv");
    exit(1);
  }

  // Print the server response
  printf("%s", recvbuf);

  // Send the QUIT command
  char *quit = "QUIT\r\n";
  if (send(sockfd, quit, strlen(quit), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Close the socket
  close(sockfd);

  return 0;
}