//GEMINI-pro DATASET v1.0 Category: Subnet Calculator ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct _subnet {
    unsigned long ip;
    unsigned long mask;
    unsigned long gateway;
    unsigned long broadcast;
    unsigned long first_host;
    unsigned long last_host;
    unsigned long usable_hosts;
} subnet;

void subnet_calculate(subnet *s, unsigned long ip, unsigned long mask) {
    s->ip = ip;
    s->mask = mask;

    // Calculate gateway
    s->gateway = ip & mask;

    // Calculate broadcast
    s->broadcast = s->gateway | ~mask;

    // Calculate first host
    s->first_host = s->gateway + 1;

    // Calculate last host
    s->last_host = s->broadcast - 1;

    // Calculate usable hosts
    s->usable_hosts = s->last_host - s->first_host + 1;
}

void subnet_print(subnet *s) {
    printf("IP address: %lu\n", s->ip);
    printf("Subnet mask: %lu\n", s->mask);
    printf("Gateway: %lu\n", s->gateway);
    printf("Broadcast: %lu\n", s->broadcast);
    printf("First host: %lu\n", s->first_host);
    printf("Last host: %lu\n", s->last_host);
    printf("Usable hosts: %lu\n", s->usable_hosts);
}

int main(int argc, char *argv[]) {
    if (argc != 3) {
        printf("Usage: %s <IP address> <Subnet mask>\n", argv[0]);
        return 1;
    }

    unsigned long ip = strtoul(argv[1], NULL, 10);
    unsigned long mask = strtoul(argv[2], NULL, 10);

    subnet s;
    subnet_calculate(&s, ip, mask);
    subnet_print(&s);

    return 0;
}