//GPT-4o-mini DATASET v1.0 Category: Antivirus scanner ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>

#define MAX_PLAYERS 4
#define MAX_FILES 10

// Structure to hold file information
typedef struct {
    char name[50];
    int is_infected;
} File;

File files[MAX_FILES];
pthread_mutex_t lock;

// Function to simulate scanning a file
void *scan_file(void *arg) {
    int player_id = *(int *)arg;
    for (int i = 0; i < MAX_FILES; i++) {
        pthread_mutex_lock(&lock);
        // Simulate some scanning time
        printf("Player %d scanning file: %s...\n", player_id, files[i].name);
        sleep(1);
        
        // Randomly set if the file is infected (for demo purposes)
        if (rand() % 2 == 0) {
            files[i].is_infected = 1;
            printf("Player %d found a virus in file: %s\n", player_id, files[i].name);
        } else {
            files[i].is_infected = 0;
            printf("Player %d found no issues in file: %s\n", player_id, files[i].name);
        }
        pthread_mutex_unlock(&lock);
    }
    return NULL;
}

// Function to initialize files
void initialize_files() {
    for (int i = 0; i < MAX_FILES; i++) {
        snprintf(files[i].name, sizeof(files[i].name), "File%d.txt", i + 1);
        files[i].is_infected = 0; // Initially, all files are not infected
    }
}

// Main function to run the program
int main() {
    srand(time(NULL));
    pthread_t players[MAX_PLAYERS];
    int player_ids[MAX_PLAYERS];

    // Initialize mutex lock
    pthread_mutex_init(&lock, NULL);

    // Initialize file list
    initialize_files();

    printf("Welcome to the Multiplayer Antivirus Scanner!\n");
    printf("There are %d players available for scanning...\n", MAX_PLAYERS);

    // Create player threads
    for (int i = 0; i < MAX_PLAYERS; i++) {
        player_ids[i] = i + 1; // Player IDs start from 1
        if (pthread_create(&players[i], NULL, scan_file, &player_ids[i]) != 0) {
            fprintf(stderr, "Error creating thread for player %d\n", i + 1);
            return 1;
        }
    }

    // Join all player threads
    for (int i = 0; i < MAX_PLAYERS; i++) {
        pthread_join(players[i], NULL);
    }

    // Output final results
    printf("\nScanning complete! Final report:\n");
    for (int i = 0; i < MAX_FILES; i++) {
        if (files[i].is_infected) {
            printf("File %s is infected!\n", files[i].name);
        } else {
            printf("File %s is clean.\n", files[i].name);
        }
    }

    // Clean up mutex
    pthread_mutex_destroy(&lock);
    
    return 0;
}