//GEMINI-pro DATASET v1.0 Category: Data mining ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef struct {
    char *name;
    int age;
    double salary;
} person_t;

int compare_by_age(const void *a, const void *b) {
    person_t *p1 = (person_t *)a;
    person_t *p2 = (person_t *)b;
    return p1->age - p2->age;
}

int compare_by_salary(const void *a, const void *b) {
    person_t *p1 = (person_t *)a;
    person_t *p2 = (person_t *)b;
    return p1->salary - p2->salary;
}

int main() {
    // Create an array of persons
    person_t persons[] = {
        {"John Doe", 30, 40000.0},
        {"Jane Smith", 25, 35000.0},
        {"Bill Jones", 40, 50000.0},
        {"Mary Johnson", 35, 45000.0},
        {"Tom Brown", 28, 38000.0},
    };

    // Sort the array of persons by age
    qsort(persons, sizeof(persons) / sizeof(person_t), sizeof(person_t), compare_by_age);

    // Print the sorted array of persons
    printf("Sorted by age:\n");
    for (int i = 0; i < sizeof(persons) / sizeof(person_t); i++) {
        printf("%s (%d, %f)\n", persons[i].name, persons[i].age, persons[i].salary);
    }

    // Sort the array of persons by salary
    qsort(persons, sizeof(persons) / sizeof(person_t), sizeof(person_t), compare_by_salary);

    // Print the sorted array of persons
    printf("Sorted by salary:\n");
    for (int i = 0; i < sizeof(persons) / sizeof(person_t); i++) {
        printf("%s (%d, %f)\n", persons[i].name, persons[i].age, persons[i].salary);
    }

    return 0;
}