//Falcon-180B DATASET v1.0 Category: Building a SMTP Client ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <time.h>

#define SERVER_PORT 25
#define SERVER_ADDRESS "127.0.0.1"
#define BUFFER_SIZE 1024

int main() {
    int sockfd;
    struct sockaddr_in server_addr;
    char buffer[BUFFER_SIZE];

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        printf("Error creating socket\n");
        exit(1);
    }

    // Set server address
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    inet_pton(AF_INET, SERVER_ADDRESS, &server_addr.sin_addr);

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        printf("Error connecting to server\n");
        exit(1);
    }

    // Send HELO command
    send(sockfd, "HELO client\r\n", strlen("HELO client\r\n"), 0);

    // Send MAIL FROM command
    send(sockfd, "MAIL FROM: sender@example.com\r\n", strlen("MAIL FROM: sender@example.com\r\n"), 0);

    // Send RCPT TO command
    send(sockfd, "RCPT TO: recipient@example.com\r\n", strlen("RCPT TO: recipient@example.com\r\n"), 0);

    // Send DATA command
    send(sockfd, "DATA\r\n", strlen("DATA\r\n"), 0);

    // Send message body
    send(sockfd, "Subject: Test Message\r\n\r\nThis is a test message.\r\n.\r\n", strlen("Subject: Test Message\r\n\r\nThis is a test message.\r\n.\r\n"), 0);

    // Receive server response
    memset(buffer, 0, BUFFER_SIZE);
    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("Server response: %s\n", buffer);

    // Close socket
    close(sockfd);

    return 0;
}