//GEMINI-pro DATASET v1.0 Category: File system simulation ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// File system data structures
typedef struct {
  char name[16];
  int size;
  int start;
} File;

typedef struct {
  File files[10];
  int num_files;
  int free_space;
} Directory;

// Initialize the file system
Directory directory = {
  .num_files = 0,
  .free_space = 100
};

// Create a new file
int create_file(char *name, int size) {
  if (directory.num_files == 10) {
    return -1; // File system is full
  }

  if (size > directory.free_space) {
    return -2; // Not enough free space
  }

  // Find a free slot in the directory
  int i;
  for (i = 0; i < 10; i++) {
    if (directory.files[i].name[0] == '\0') {
      break;
    }
  }

  if (i == 10) {
    return -3; // No free slots in the directory
  }

  // Add the file to the directory
  strcpy(directory.files[i].name, name);
  directory.files[i].size = size;
  directory.files[i].start = directory.free_space;

  // Update the free space
  directory.free_space -= size;

  return 0;
}

// Delete a file
int delete_file(char *name) {
  // Find the file in the directory
  int i;
  for (i = 0; i < 10; i++) {
    if (strcmp(directory.files[i].name, name) == 0) {
      break;
    }
  }

  if (i == 10) {
    return -1; // File not found
  }

  // Remove the file from the directory
  directory.files[i].name[0] = '\0';
  directory.files[i].size = 0;
  directory.files[i].start = 0;

  // Update the free space
  directory.free_space += directory.files[i].size;

  return 0;
}

// List the files in the directory
void list_files() {
  // Print the header
  printf("%-16s %-8s %-10s\n", "Name", "Size", "Start");

  // Print the files
  int i;
  for (i = 0; i < 10; i++) {
    if (directory.files[i].name[0] != '\0') {
      printf("%-16s %-8d %-10d\n", directory.files[i].name, directory.files[i].size, directory.files[i].start);
    }
  }
}

// Main function
int main() {
  // Create some files
  create_file("file1.txt", 10);
  create_file("file2.txt", 20);
  create_file("file3.txt", 30);

  // List the files
  list_files();

  // Delete a file
  delete_file("file2.txt");

  // List the files again
  list_files();

  return 0;
}