//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <math.h>
#include <stdbool.h>

#define MAX_STOCKS 100
#define MAX_NAME_LENGTH 10
#define MAX_SYMBOL_LENGTH 10
#define MAX_PRICE_LENGTH 10

typedef struct {
    char name[MAX_NAME_LENGTH];
    char symbol[MAX_SYMBOL_LENGTH];
    double price;
} Stock;

Stock stocks[MAX_STOCKS];
int num_stocks;

void init() {
    num_stocks = 0;
}

void add_stock(const char* name, const char* symbol, double price) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: cannot add more than %d stocks\n", MAX_STOCKS);
        return;
    }

    strcpy(stocks[num_stocks].name, name);
    strcpy(stocks[num_stocks].symbol, symbol);
    stocks[num_stocks].price = price;

    num_stocks++;
}

void display_stocks() {
    printf("Name\tSymbol\tPrice\n");

    for (int i = 0; i < num_stocks; i++) {
        printf("%s\t%s\t%.2f\n", stocks[i].name, stocks[i].symbol, stocks[i].price);
    }
}

void search_stock(const char* name) {
    for (int i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            printf("Found stock:\n");
            printf("Name: %s\n", stocks[i].name);
            printf("Symbol: %s\n", stocks[i].symbol);
            printf("Price: %.2f\n", stocks[i].price);
        }
    }
}

int main() {
    init();

    add_stock("Apple", "AAPL", 150.00);
    add_stock("Google", "GOOG", 1000.00);
    add_stock("Microsoft", "MSFT", 200.00);

    display_stocks();

    search_stock("Google");

    return 0;
}