//Falcon-180B DATASET v1.0 Category: RAM usage monitor ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 1024

typedef struct process {
    char name[16];
    int pid;
    int memory;
} process_t;

int num_processes = 0;
process_t processes[MAX_PROCESSES];

void add_process(char* name, int pid, int memory) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: maximum number of processes reached\n");
        return;
    }

    strncpy(processes[num_processes].name, name, 16);
    processes[num_processes].pid = pid;
    processes[num_processes].memory = memory;

    num_processes++;
}

void remove_process(int pid) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            num_processes--;
            break;
        }
    }
}

void update_process_memory(int pid, int new_memory) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            processes[i].memory = new_memory;
            break;
        }
    }
}

void print_processes() {
    printf("Processes:\n");
    printf("----------------------\n");
    printf("PID\tName\tMemory\n");
    printf("----------------------\n");

    int i;
    for (i = 0; i < num_processes; i++) {
        printf("%d\t%s\t%d\n", processes[i].pid, processes[i].name, processes[i].memory);
    }
}

int main() {
    add_process("chrome", 1234, 500);
    add_process("firefox", 5678, 300);
    add_process("explorer", 9012, 200);

    print_processes();

    remove_process(5678);

    print_processes();

    update_process_memory(1234, 600);

    print_processes();

    return 0;
}