//Code Llama-13B DATASET v1.0 Category: Database simulation ; Style: complex
// database_simulation.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_NAME_LENGTH 20
#define MAX_ADDRESS_LENGTH 50
#define MAX_AGE 150

typedef struct {
  char name[MAX_NAME_LENGTH];
  char address[MAX_ADDRESS_LENGTH];
  int age;
} person_t;

void add_person(person_t* people, int* num_people, char* name, char* address, int age) {
  if (*num_people == MAX_NAME_LENGTH) {
    printf("The database is full.\n");
    return;
  }
  strcpy(people[*num_people].name, name);
  strcpy(people[*num_people].address, address);
  people[*num_people].age = age;
  (*num_people)++;
}

void delete_person(person_t* people, int* num_people, int index) {
  if (index < 0 || index >= *num_people) {
    printf("Invalid index.\n");
    return;
  }
  for (int i = index; i < *num_people - 1; i++) {
    people[i] = people[i + 1];
  }
  (*num_people)--;
}

void update_person(person_t* people, int* num_people, int index, char* name, char* address, int age) {
  if (index < 0 || index >= *num_people) {
    printf("Invalid index.\n");
    return;
  }
  strcpy(people[index].name, name);
  strcpy(people[index].address, address);
  people[index].age = age;
}

void print_person(person_t* people, int* num_people, int index) {
  if (index < 0 || index >= *num_people) {
    printf("Invalid index.\n");
    return;
  }
  printf("Name: %s\n", people[index].name);
  printf("Address: %s\n", people[index].address);
  printf("Age: %d\n", people[index].age);
}

void print_all_people(person_t* people, int* num_people) {
  for (int i = 0; i < *num_people; i++) {
    printf("Person %d:\n", i);
    print_person(people, num_people, i);
  }
}

int main() {
  person_t people[MAX_NAME_LENGTH];
  int num_people = 0;

  add_person(people, &num_people, "John Doe", "123 Main St", 30);
  add_person(people, &num_people, "Jane Doe", "456 Elm St", 35);
  add_person(people, &num_people, "Bob Smith", "789 Oak St", 40);

  print_all_people(people, &num_people);

  delete_person(people, &num_people, 1);

  print_all_people(people, &num_people);

  update_person(people, &num_people, 0, "Johnathan Doe", "123 Main St", 31);

  print_all_people(people, &num_people);

  return 0;
}