//Code Llama-13B DATASET v1.0 Category: Mortgage Calculator ; Style: curious
// A curious C Mortgage Calculator example program

#include <stdio.h>

// Define the structure for the mortgage information
struct Mortgage {
    double principal; // The amount borrowed
    double interest; // The interest rate as a decimal
    int years; // The number of years the mortgage lasts
};

// Define the structure for the mortgage payment
struct Payment {
    double principal; // The amount paid towards the principal
    double interest; // The amount paid towards the interest
    double total; // The total amount paid
};

// Define the function to calculate the monthly mortgage payment
struct Payment calculate_monthly_payment(struct Mortgage m) {
    // Calculate the monthly interest rate
    double monthly_interest = m.interest / 12;

    // Calculate the number of months
    int months = m.years * 12;

    // Calculate the monthly principal
    double monthly_principal = m.principal / months;

    // Calculate the monthly interest
    double monthly_interest_payment = monthly_principal * monthly_interest;

    // Calculate the total monthly payment
    double total_monthly_payment = monthly_principal + monthly_interest_payment;

    // Return the monthly payment
    return (struct Payment) {
        .principal = monthly_principal,
        .interest = monthly_interest_payment,
        .total = total_monthly_payment
    };
}

int main() {
    // Initialize the mortgage information
    struct Mortgage m = {
        .principal = 100000,
        .interest = 0.05,
        .years = 30
    };

    // Calculate the monthly payment
    struct Payment p = calculate_monthly_payment(m);

    // Print the monthly payment information
    printf("Monthly payment: $%.2f\n", p.total);

    return 0;
}