//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/wait.h>

#define MAX_MSG_SIZE 1000
#define QUEUE_KEY 1234
#define SEM_KEY 5678

struct msg_buffer {
    long mtype;
    char mtext[MAX_MSG_SIZE];
};

int main() {
    int msg_id, sem_id;
    key_t queue_key = QUEUE_KEY, sem_key = SEM_KEY;
    struct msg_buffer msg;
    pid_t child_pid;

    // Create a message queue
    msg_id = msgget(queue_key, 0666 | IPC_CREAT);
    if (msg_id == -1) {
        printf("Error creating message queue\n");
        exit(1);
    }

    // Fork a child process
    child_pid = fork();
    if (child_pid == 0) {
        // Child process
        sleep(1);
        strcpy(msg.mtext, "Hello from child process");
        msg.mtype = 1;
        msgsnd(msg_id, &msg, strlen(msg.mtext) + 1, 0);
        exit(0);
    } else if (child_pid < 0) {
        printf("Error forking child process\n");
        exit(1);
    } else {
        // Parent process
        sleep(2);
        memset(&msg, 0, sizeof(msg));
        msgrcv(msg_id, &msg, MAX_MSG_SIZE, 1, 0);
        printf("Received message: %s\n", msg.mtext);
        exit(0);
    }

    return 0;
}