//GEMINI-pro DATASET v1.0 Category: Email Client ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#define PORT 25

int main() {
    int sockfd;
    struct sockaddr_in servaddr;

    // Create a socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket");
        exit(1);
    }

    // Set the server address
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(PORT);
    servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("connect");
        exit(1);
    }

    // Send the HELO command
    char *helo = "HELO example.com\r\n";
    if (send(sockfd, helo, strlen(helo), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive the server's response
    char buffer[1024];
    if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
        perror("recv");
        exit(1);
    }

    // Print the server's response
    printf("%s", buffer);

    // Send the MAIL FROM command
    char *mailfrom = "MAIL FROM: <example@example.com>\r\n";
    if (send(sockfd, mailfrom, strlen(mailfrom), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive the server's response
    if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
        perror("recv");
        exit(1);
    }

    // Print the server's response
    printf("%s", buffer);

    // Send the RCPT TO command
    char *rcptto = "RCPT TO: <example@example.com>\r\n";
    if (send(sockfd, rcptto, strlen(rcptto), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive the server's response
    if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
        perror("recv");
        exit(1);
    }

    // Print the server's response
    printf("%s", buffer);

    // Send the DATA command
    char *data = "DATA\r\n";
    if (send(sockfd, data, strlen(data), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive the server's response
    if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
        perror("recv");
        exit(1);
    }

    // Print the server's response
    printf("%s", buffer);

    // Send the email body
    char *body = "This is an example email body.\r\n";
    if (send(sockfd, body, strlen(body), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Send the end of the email body
    char *eob = ".\r\n";
    if (send(sockfd, eob, strlen(eob), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive the server's response
    if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
        perror("recv");
        exit(1);
    }

    // Print the server's response
    printf("%s", buffer);

    // Send the QUIT command
    char *quit = "QUIT\r\n";
    if (send(sockfd, quit, strlen(quit), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Close the socket
    close(sockfd);

    return 0;
}