//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#define MAX_NODES 1000
#define MAX_LINKS 10000
#define NODE_NAME_LENGTH 50
#define LINK_NAME_LENGTH 50

typedef struct {
    char name[NODE_NAME_LENGTH];
    int id;
} node_t;

typedef struct {
    char name[LINK_NAME_LENGTH];
    int source_id;
    int destination_id;
} link_t;

node_t nodes[MAX_NODES];
link_t links[MAX_LINKS];
int num_nodes = 0;
int num_links = 0;

void add_node(char* name) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

int get_node_id(char* name) {
    for (int i = 0; i < num_nodes; i++) {
        if (strcmp(nodes[i].name, name) == 0) {
            return nodes[i].id;
        }
    }
    return -1;
}

void add_link(char* name, int source_id, int destination_id) {
    strcpy(links[num_links].name, name);
    links[num_links].source_id = source_id;
    links[num_links].destination_id = destination_id;
    num_links++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d. %s\n", i, nodes[i].name);
    }
}

void print_links() {
    printf("Links:\n");
    for (int i = 0; i < num_links; i++) {
        printf("%s (%d -> %d)\n", links[i].name, links[i].source_id, links[i].destination_id);
    }
}

int main() {
    // Example usage
    add_node("Node 1");
    add_node("Node 2");
    add_node("Node 3");
    add_link("Link 1", 0, 1);
    add_link("Link 2", 1, 2);
    add_link("Link 3", 2, 0);
    print_nodes();
    print_links();
    return 0;
}