//Falcon-180B DATASET v1.0 Category: TCP/IP Programming ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080
#define MAX_CLIENTS 5
#define BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int server_socket = 0;
    struct sockaddr_in server_addr;
    int opt = 1;
    int client_socket[MAX_CLIENTS];
    int max_clients = 0;
    int addr_size;
    char buffer[BUFFER_SIZE];

    if ((server_socket = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    if (setsockopt(server_socket, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))) {
        perror("setsockopt");
        exit(EXIT_FAILURE);
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(PORT);

    if (bind(server_socket, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    if (listen(server_socket, MAX_CLIENTS) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    printf("Server is listening on port %d\n", PORT);

    while (1) {
        addr_size = sizeof(struct sockaddr_in);
        if ((client_socket[max_clients] = accept(server_socket, (struct sockaddr *)&server_addr, &addr_size)) < 0) {
            perror("accept");
            exit(EXIT_FAILURE);
        }

        printf("New client connected\n");

        if (max_clients == MAX_CLIENTS - 1) {
            printf("Maximum number of clients reached\n");
            break;
        }

        max_clients++;
    }

    for (int i = 0; i < max_clients; i++) {
        memset(buffer, 0, BUFFER_SIZE);
        if (recv(client_socket[i], buffer, BUFFER_SIZE, 0) <= 0) {
            close(client_socket[i]);
            printf("Client %d disconnected\n", i);
        } else {
            send(client_socket[i], buffer, strlen(buffer), 0);
        }
    }

    close(server_socket);
    return 0;
}