//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: visionary
// The Celestial Phone Book

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define MAX_NAME_LENGTH 50
#define MAX_NUMBER_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH];
    char number[MAX_NUMBER_LENGTH];
} contact_t;

contact_t contacts[10];
int num_contacts = 0;

void add_contact(char *name, char *number);
void print_contacts();

int main() {
    setbuf(stdin, NULL);
    setbuf(stdout, NULL);

    // Initialize the phone book
    for (int i = 0; i < 10; i++) {
        contacts[i].name[0] = '\0';
        contacts[i].number[0] = '\0';
    }

    // Add some contacts
    add_contact("Astrid", "555-1234");
    add_contact("Bryce", "555-5678");
    add_contact("Cassandra", "555-9012");
    add_contact("Draco", "555-1111");

    // Print the contacts
    print_contacts();

    return 0;
}

void add_contact(char *name, char *number) {
    int i;
    for (i = 0; i < num_contacts; i++) {
        if (strcmp(contacts[i].name, name) == 0) {
            // Contact already exists, update the number
            strcpy(contacts[i].number, number);
            return;
        }
    }

    // Contact does not exist, add it
    if (num_contacts < 10) {
        strcpy(contacts[num_contacts].name, name);
        strcpy(contacts[num_contacts].number, number);
        num_contacts++;
    } else {
        printf("Sorry, the phone book is full. Please delete some "
                 "existing contacts to add more.\n");
    }
}

void print_contacts() {
    int i;
    for (i = 0; i < num_contacts; i++) {
        printf("%d. %s %s\n", i + 1, contacts[i].name, contacts[i].number);
    }
}