//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50
#define MAX_FILE_CONTENTS_LENGTH 1000

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char contents[MAX_FILE_CONTENTS_LENGTH];
    int size;
} File;

File files[MAX_FILES];
int num_files = 0;

void create_file(char* name, char* contents) {
    if (num_files >= MAX_FILES) {
        printf("Error: Max number of files reached\n");
        return;
    }

    strcpy(files[num_files].name, name);
    strcpy(files[num_files].contents, contents);
    files[num_files].size = strlen(contents);

    num_files++;
}

void delete_file(char* name) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            num_files--;

            if (i < num_files) {
                memmove(&files[i], &files[i+1], sizeof(File) * (num_files - i - 1));
            }

            break;
        }
    }
}

void rename_file(char* old_name, char* new_name) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, old_name) == 0) {
            strcpy(files[i].name, new_name);

            break;
        }
    }
}

void display_files() {
    int i;

    for (i = 0; i < num_files; i++) {
        printf("%s (%d bytes)\n", files[i].name, files[i].size);
    }
}

int main() {
    create_file("test.txt", "Hello, World!");
    create_file("test2.txt", "This is a test file.");

    display_files();

    rename_file("test.txt", "new_test.txt");

    display_files();

    delete_file("test2.txt");

    display_files();

    return 0;
}