//LLAMA2-13B DATASET v1.0 Category: Port Scanner ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_CLIENT_LEN 1024
#define MAX_PORTS 65536

struct client_info {
    int sock;
    char ip[16];
    char port[6];
};

int main(void) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket failed");
        return 1;
    }

    // Set up the server socket
    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_addr.s_addr = INADDR_ANY,
        .sin_port = htons(8080)
    };
    if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind failed");
        return 1;
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("listen failed");
        return 1;
    }

    // Accept an incoming connection
    struct client_info client;
    sock = accept(sock, (struct sockaddr *)&client.ip, (socklen_t*)&client.port);
    if (sock < 0) {
        perror("accept failed");
        return 1;
    }

    // Print the client's IP address and port number
    printf("Client connected from IP address %s and port %s\n", client.ip, client.port);

    // Send a mysterious message to the client
    char message[] = "Welcome, brave adventurer!";
    send(sock, message, strlen(message), 0);

    // Receive a response from the client
    char buffer[1024];
    recv(sock, buffer, 1024, 0);
    printf("Client responded with: %s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}

// Function to convert a socket address to a human-readable string
void socket_addr_to_str(struct sockaddr_in *addr, char *str) {
    char *ip = inet_ntoa(addr->sin_addr);
    sprintf(str, "%s:%d", ip, ntohs(addr->sin_port));
}