//MISTRAL-7B DATASET v1.0 Category: Graph Coloring Problem ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#define MAX_VERTICES 10

// Define the graph structure
typedef struct Graph {
    int adj_matrix[MAX_VERTICES][MAX_VERTICES];
    int num_vertices;
} Graph;

// Function to initialize the graph
void initialize_graph(Graph *graph, int num_vertices) {
    graph->num_vertices = num_vertices;

    // Initialize the adjacency matrix with zeros
    for (int i = 0; i < num_vertices; i++) {
        for (int j = 0; j < num_vertices; j++) {
            graph->adj_matrix[i][j] = 0;
        }
    }
}

// Function to add an edge between two vertices
void add_edge(Graph *graph, int src, int dest) {
    graph->adj_matrix[src][dest] = 1;
    graph->adj_matrix[dest][src] = 1;
}

// Function to check if a vertex is safe to color with a given color
int is_safe(Graph *graph, int vertex, int color, int *color_assigned) {
    for (int i = 0; i < graph->num_vertices; i++) {
        if (graph->adj_matrix[vertex][i] == 1 && color_assigned[i] == color) {
            return 0;
        }
    }

    return 1;
}

// Function to find the maximum number of vertices that can be colored with a given color
int find_max_safe_vertices(Graph *graph, int color, int *color_assigned) {
    int max_safe = 0;

    for (int i = 0; i < graph->num_vertices; i++) {
        if (is_safe(graph, i, color, color_assigned)) {
            max_safe++;
            color_assigned[i] = color;
        }
    }

    return max_safe;
}

// Function to print the colored graph
void print_colored_graph(Graph *graph, int *color_assigned) {
    printf("Colored Graph:\n");

    for (int i = 0; i < graph->num_vertices; i++) {
        printf("%d: %d\n", i, color_assigned[i]);
    }
}

int main() {
    // Initialize the graph
    Graph graph;
    initialize_graph(&graph, 5);

    // Add edges between vertices
    add_edge(&graph, 0, 1);
    add_edge(&graph, 0, 2);
    add_edge(&graph, 1, 2);
    add_edge(&graph, 1, 4);
    add_edge(&graph, 2, 3);
    add_edge(&graph, 3, 4);

    // Initialize color assignment for all vertices
    int color_assigned[MAX_VERTICES];
    for (int i = 0; i < graph.num_vertices; i++) {
        color_assigned[i] = -1;
    }

    // Color the vertices using Depth First Search algorithm
    int current_color = 0;
    for (int i = 0; i < graph.num_vertices; i++) {
        if (color_assigned[i] == -1) {
            int num_safe = find_max_safe_vertices(&graph, current_color++, color_assigned);
            printf("Color %d can be assigned to %d vertices:\n", current_color - 1, num_safe);
        }
    }

    // Print the colored graph
    print_colored_graph(&graph, color_assigned);

    return 0;
}