//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    int size;
    int permissions;
} File;

File files[MAX_FILES];
int num_files = 0;

void create_file(char* name, int size, int permissions) {
    if (num_files >= MAX_FILES) {
        printf("Error: Too many files.\n");
        return;
    }
    File file = {.name = name,.size = size,.permissions = permissions };
    files[num_files++] = file;
}

void delete_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            num_files--;
            memmove(&files[i], &files[i+1], sizeof(File) * (num_files - i));
            break;
        }
    }
}

void list_files() {
    int i;
    for (i = 0; i < num_files; i++) {
        printf("%s (%d bytes) - permissions %d\n", files[i].name, files[i].size, files[i].permissions);
    }
}

int main() {
    create_file("test.txt", 10, 0644);
    create_file("test2.txt", 20, 0755);
    list_files();
    delete_file("test.txt");
    list_files();
    return 0;
}