//GPT-4o-mini DATASET v1.0 Category: Chess engine ; Style: scalable
#include <stdio.h>
#include <stdlib.h>

#define BOARD_SIZE 8
#define EMPTY '.'

// Piece representation
typedef enum {
    PAWN, KNIGHT, BISHOP, ROOK, QUEEN, KING, NONE
} Piece;

typedef struct {
    Piece board[BOARD_SIZE][BOARD_SIZE];
    char colors[BOARD_SIZE][BOARD_SIZE]; // 'W' for white, 'B' for black
} ChessBoard;

// Function declarations
void initBoard(ChessBoard *b);
void printBoard(const ChessBoard *b);
int isMoveValid(const ChessBoard *b, int startX, int startY, int endX, int endY);
void makeMove(ChessBoard *b, int startX, int startY, int endX, int endY);
void cleanupBoard(ChessBoard *b);

int main() {
    ChessBoard board;
    initBoard(&board);
    printBoard(&board);
    
    // Example move: Move a pawn from (1, 0) to (3, 0)
    if (isMoveValid(&board, 1, 0, 3, 0)) {
        makeMove(&board, 1, 0, 3, 0);
    }
    
    printBoard(&board);
    
    cleanupBoard(&board);
    return 0;
}

void initBoard(ChessBoard *b) {
    // Initialize the board to empty squares
    for (int x = 0; x < BOARD_SIZE; x++)
        for (int y = 0; y < BOARD_SIZE; y++) {
            b->board[x][y] = NONE;
            b->colors[x][y] = EMPTY;
        }
    
    // Place pieces on the board (simplified setup)
    b->board[0][0] = b->board[0][7] = ROOK;
    b->board[0][1] = b->board[0][6] = KNIGHT;
    b->board[0][2] = b->board[0][5] = BISHOP;
    b->board[0][3] = QUEEN;
    b->board[0][4] = KING;
    
    for (int i = 0; i < BOARD_SIZE; i++) {
        b->board[1][i] = PAWN;
        b->colors[1][i] = 'W'; // White pawns
    }

    for (int i = 0; i < BOARD_SIZE; i++) {
        b->colors[0][i] = 'W'; // White pieces
    }
}

void printBoard(const ChessBoard *b) {
    for (int x = 0; x < BOARD_SIZE; x++) {
        for (int y = 0; y < BOARD_SIZE; y++) {
            if (b->board[x][y] == NONE) {
                printf("%c ", EMPTY);
            } else {
                printf("%c ", b->colors[x][y]);
            }
        }
        printf("\n");
    }
}

int isMoveValid(const ChessBoard *b, int startX, int startY, int endX, int endY) {
    // Basic validation (more rules to be added)
    if (startX < 0 || startX >= BOARD_SIZE || startY < 0 || startY >= BOARD_SIZE ||
        endX < 0 || endX >= BOARD_SIZE || endY < 0 || endY >= BOARD_SIZE) {
        return 0; // Out of bounds
    }
    if (b->board[startX][startY] == NONE) {
        return 0; // No piece at start
    }
    return 1; // Valid for now
}

void makeMove(ChessBoard *b, int startX, int startY, int endX, int endY) {
    b->board[endX][endY] = b->board[startX][startY];
    b->colors[endX][endY] = b->colors[startX][startY];
    b->board[startX][startY] = NONE;
    b->colors[startX][startY] = EMPTY;
}

void cleanupBoard(ChessBoard *b) {
    // Free up any dynamic structures if there were any
    // (none here for a simple representation)
}