//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: excited
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

typedef struct Car {
  int lane;
  int position;
  int speed;
} Car;

void simulateTrafficFlow(Car cars[], int numCars) {
  for (int i = 0; i < numCars; i++) {
    cars[i].position++;
    if (cars[i].position >= MAX_LANE * 5) {
      cars[i].position = 0;
    }
    switch (cars[i].lane) {
      case 0:
        if (cars[i].position % MAX_LANE == 0) {
          cars[i].lane = 1;
        }
        break;
      case 1:
        if (cars[i].position % MAX_LANE == MAX_LANE - 1) {
          cars[i].lane = 2;
        }
        break;
      case 2:
        if (cars[i].position % MAX_LANE == MAX_LANE - 1) {
          cars[i].lane = 0;
        }
        break;
    }
  }
}

int main() {
  srand(time(NULL));

  Car cars[MAX_CARS];
  for (int i = 0; i < MAX_CARS; i++) {
    cars[i].lane = rand() % MAX_LANE;
    cars[i].position = rand() % MAX_LANE * 5;
    cars[i].speed = rand() % 5 + 1;
  }

  simulateTrafficFlow(cars, MAX_CARS);

  for (int i = 0; i < MAX_CARS; i++) {
    printf("Car %d: lane %d, position %d, speed %d\n", i, cars[i].lane, cars[i].position, cars[i].speed);
  }

  return 0;
}